% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aId.R
\name{aIc.dominant}
\alias{aIc.dominant}
\title{\code{aIc.dominant} calculates the subcompositional dominance of a sample in
  a dataset for a given correction. This compares the distances of samples
  of the full dataset and a subset of the dataset.
  This is expected to be true if the transform is behaving rationally in
  compositional datasets.}
\usage{
aIc.dominant(
  data,
  norm.method = "prop",
  zero.remove = 0.95,
  zero.method = "prior",
  log = FALSE,
  distance = "euclidian",
  group = NULL
)
}
\arguments{
\item{data}{can be any dataframe or matrix with samples by column}

\item{norm.method}{can be prop, clr, RLE, TMM, TMMwsp}

\item{zero.remove}{is a value. Filter data to remove features that are 0 
across at least that proportion of samples: default 0.95}

\item{zero.method}{can be any of NULL, prior, GBM or CZM. NULL will not 
impute or change 0 values, GBM (preferred) and CZM are from the 
zCompositions R package, and prior will simply add 0.5 to all counts.}

\item{log}{is a logical. log transform the RLE or TMM outputs, default=FALSE}

\item{distance}{can be euclidian, bray, or jaccard. euclidian on log-ratio
transformed data is the same as the Aitchison distance. default=euclidian}

\item{group}{is a vector containing group information. Required for clr, RLE, 
TMM, lvha, and iqlr based normalizations.}
}
\value{
Returns a list with the overlap between distances in the full and 
  subcompositon in \code{ol} (expect 0), a yes/no binary decision in 
  \code{is.dominant} and the table of distances for the whole and subcomposition
  in \code{dist.all} and \code{dist.sub}, a plot showing a histogram of the resulting
  overlap in distances in \code{plot}, and the plot and axis
  labels in \code{main} \code{xlab} and \code{ylab}
}
\description{
\code{aIc.dominant} calculates the subcompositional dominance of a sample in
  a dataset for a given correction. This compares the distances of samples
  of the full dataset and a subset of the dataset.
  This is expected to be true if the transform is behaving rationally in
  compositional datasets.
}
\examples{
data(selex)
group = c(rep('N', 7), rep('S', 7))
x <- aIc.dominant(selex, group=group, norm.method='clr', distance='euclidian', zero.method='prior')
plot(x$plot, main=x$main, ylab=x$ylab, xlab=x$xlab)
}
\author{
Greg Gloor
}
