% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aIsc.R
\name{aIc.scale}
\alias{aIc.scale}
\title{\code{aIc.scale} calculates the scaling invariance of a sample in
  a dataset for a given correction. This compares the distances of samples
  of the full dataset and a scaled version of the dataset.
  This is expected to be true if the transform is behaving rationally in
  compositional datasets.}
\usage{
aIc.scale(
  data,
  norm.method = "prop",
  zero.remove = 0.95,
  zero.method = "prior",
  distance = "euclidian",
  log = FALSE,
  group = NULL
)
}
\arguments{
\item{data}{can be any dataframe or matrix with samples by column}

\item{norm.method}{can be prop, clr, iqlr, lvha, RLE, TMM, TMMwsp}

\item{zero.remove}{is a value. Filter data to remove features that are 0 
across at least that proportion of samples: default 0.95}

\item{zero.method}{can be any of NULL, prior, GBM or CZM. NULL will not 
impute or change 0 values, GBM (preferred) and CZM are from the 
zCompositions R package, and prior will simply add 0.5 to all counts.}

\item{distance}{can be euclidian, bray, or jaccard. euclidian on log-ratio
transformed data is the same as the Aitchison distance. default=euclidian}

\item{log}{is a logical. log transform the RLE or TMM outputs, default=FALSE}

\item{group}{is a vector containing group information. Required for clr, RLE, 
TMM, lvha, and iqlr based normalizations.}
}
\value{
Returns a list with the overlap between distances in the full and 
  scaled composition in \code{ol} (expect 0), a yes/no binary decision in 
  \code{is.scale} and the table of distances for the whole and scaled composition
  in \code{dist.all} and \code{dist.scale}, a plot showing a histogram of the resulting
  overlap in distances in \code{plot}, and the plot and axis
  labels in \code{main} \code{xlab} and \code{ylab}
}
\description{
\code{aIc.scale} calculates the scaling invariance of a sample in
  a dataset for a given correction. This compares the distances of samples
  of the full dataset and a scaled version of the dataset.
  This is expected to be true if the transform is behaving rationally in
  compositional datasets.
}
\examples{
data(selex)
group = c(rep('N', 7), rep('S', 7))
x <- aIc.scale(selex, group=group, norm.method='clr', zero.method='prior')
plot(x$plot, main=x$main, ylab=x$ylab, xlab=x$xlab)
}
\author{
Greg Gloor
}
