% Generated by roxygen2 (4.0.2): do not edit by hand
\name{trend.test}
\alias{trend.test}
\title{Trend Test}
\usage{
trend.test(x, method = c("cox.stuart", "diff.sign"), plot = FALSE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{method}{test method. The default is \code{method = "cox.stuart"}.}

\item{plot}{a logical value indicating to display the plot of data.
The default is \code{FALSE}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{data.name}{a character string giving the names of the data.}
\item{method}{the type of test applied.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.value}{the p-value for the test.}
\item{statistic}{the value of the test statistic with a name describing it.}
}
\description{
Performs an approximate Cox-Stuart or Difference-Sign trend test.
}
\details{
Cox-Stuart or Difference-Sign test is used to test whether the data have a
increasing or decreasing trend. They are useful to detect the linear or nonlinear trend.
The Cox-Stuart test is constructed as follows.
For the given data \eqn{x[1],...,x[t]}, one can divide them into two sequences with
equal number of observations cutted in the midpoint and then take the paired difference,
i.e., \eqn{D = x[i] - x[i+c], i = 1, ..., floor(n/2)}, where \eqn{c} is the index of
midpoint. Let \eqn{S} be the number of positive or negative values in \eqn{D}. Under the
null hypothesis that data have no trend, for large \eqn{n} = length(x), \eqn{S} is
approximately distributed as \eqn{N(n/2,n/4)}, such that one can immediately obtain
the p value. The exact Cox-Stuart trend test can be seen in \code{cs.test} of
\code{snpar} package.

The Difference-Sign test is constructed as the similar way as Cox-Stuart test. We first
let \eqn{D = x[i] - x[i - 1]} for \eqn{i = 2, ..., n} and then
count the number of positive or negative values in \eqn{D}, defined as \eqn{S}.
Under the null hypothesis, \eqn{S} is approximately distributed as
\eqn{N((n-1)/2,(n+1)/12)}. Thus, p-value can be calculated based on the null distribution.
}
\note{
Missing values are removed.
}
\examples{
x <- rnorm(100)
trend.test(x,plot = TRUE) # no trend

x <- 5*(1:100)/100
x <- x + arima.sim(list(order = c(1,0,0),ar = 0.4),n = 100)
trend.test(x,plot = TRUE) # increasing trend
}
\author{
Debin Qiu
}
\references{
D.R. Cox and A. Stuart (1955). Some quick sign tests for trend in location
and dispersion. \emph{Biometrika}, Vol. 42, pp. 80-95.

P.J. Brockwell, R.A. Davis, Time Series: Theory and Methods, second ed.,
Springer, New York, 1991. (p. 37)
}

