% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{berger_parker_d}
\alias{berger_parker_d}
\title{Berger-Parker dominance}
\usage{
berger_parker_d(x)
}
\arguments{
\item{x}{A numeric vector of species counts or proportions.}
}
\value{
The Berger-Parker dominance, \eqn{0 < D_{BP} \leq 1}. If the vector
  sums to zero, the Berger-Parker dominance is undefined, and we return
  \code{NaN}.
}
\description{
The Berger-Parker dominance is the proportion of the most abundant species.
}
\details{
\itemize{
  \item Equivalent to \code{berger_parker_d()} in
    \code{skbio.diversity.alpha}.
  \item Equivalent to the \code{bergerparker} calculator in Mothur.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
berger_parker_d(x) # 15 / 28
}
\references{
Berger WH, Parker FL. Diversity of Planktonic Foraminifera in Deep-Sea
Sediments. Science. 1970;168(3937):1345-1347.
}
