% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{hamming}
\alias{hamming}
\title{Hamming distance}
\usage{
hamming(x, y)
}
\arguments{
\item{x, y}{Numeric vectors.}
}
\value{
The Hamming distance between \code{x} and \code{y}.
}
\description{
The Hamming distance is the number of positions where the values are
different.
}
\details{
For vectors \code{x} and \code{y}, the Hamming distance is defined as
\deqn{d(x, y) = \sum_i [x_i \neq y_i],} where the quantity in the brackets
is 1 if the elements are not equal, and zero if the elements are equal.
Relation to other definitions:
\itemize{
  \item The \code{hamming()} function in \code{scipy.spatial.distance}
    divides the result by the vector length. Our function is equivalent to
    the SciPy version multiplied by the vector length.
  \item Equivalent to the \code{hamming} calculator in Mothur for
    presence/absence vectors.
}
}
