% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{ruzicka}
\alias{ruzicka}
\title{Ruzicka or weighted Jaccard distance}
\usage{
ruzicka(x, y)
}
\arguments{
\item{x, y}{Numeric vectors.}
}
\value{
The Ruzicka distance between \code{x} and \code{y}. The distance is
  not defined if all elements in \code{x} and \code{y} are zero, and we
  return \code{NaN} in this case.
}
\description{
Ruzicka or weighted Jaccard distance
}
\details{
For vectors \code{x} and \code{y}, the Ruzicka distance is defined as
\deqn{d(x, y) = 1 - \frac{\sum_i \min(x, y)}{\sum_i \max(x, y)}.} Relation
to other definitions:
\itemize{
  \item Equivalent to vegdist() with method = "jaccard".
  \item Related to the Bray-Curtis distance,
    \eqn{d_r = 2 d_{bc} / (1 + d_{bc})}.
}
}
