% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_rmd.R
\name{access_rmd}
\alias{access_rmd}
\title{Produce an accessible Rmarkdown file template.}
\usage{
access_rmd(
  filenm = NULL,
  title = NULL,
  subtitle = NULL,
  lan = NULL,
  author = Sys.info()[8],
  date = format(Sys.Date(), "\%d \%b \%Y"),
  toc = FALSE,
  encoding = "utf-8",
  force = FALSE,
  theme = "default",
  highlight = "null"
)
}
\arguments{
\item{filenm}{Required - The name of the file.}

\item{title}{Required - The document title.}

\item{subtitle}{Optional - The document subtitle.}

\item{lan}{Required - The HTML language to set as the value for the lang
attribute.}

\item{author}{Required - The document author. Defaults to the effective user
identified by \code{Sys.info()}.}

\item{date}{Required - The author date. Defaults to today's date.}

\item{toc}{Optional, defaults to FALSE. Should a table of contents be
included. Valid entries are FALSE (the default) or TRUE.}

\item{encoding}{Defaults to "utf-8".}

\item{force}{Defaults to FALSE. If TRUE, overwrites a pre-existing file with
the same filenm with warning.}

\item{theme}{Set to "default", currently the only in-built theme that does
not result in accessibility errors.}

\item{highlight}{Set to "null", currently the only in-built highlight that
does not result in accessibility errors.}
}
\value{
An Rmarkdown file with an HTML head, populated with metadata
specified within the function parameters.
}
\description{
Creates an Rmarkdown template with the HTML structure required by screen
readers.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# create an accessible rmarkdown document from scratch
access_rmd(
  "some_filenm",
  title = "Title Goes Here", lan = "en", author = "Author here"
)
\dontshow{
setwd(.old_wd)
}

}
