% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Steps7-8.R
\name{life_expectancy}
\alias{life_expectancy}
\title{Life Expectancy of Age x}
\usage{
life_expectancy(data, age, pop, deaths)
}
\arguments{
\item{data}{The mortality dataset, includes an age grouping variable,}

\item{age}{The age grouping variable, must be categorical}

\item{pop}{Population of each age group, must be numeric}

\item{deaths}{The midyear number of deaths at each age group, must be numeric}
}
\value{
Dataset that was input with the added columns:
ConditionalProbDeath, ConditionalProbLife, NumberToSurvive, PersonYears, TotalYears, and LifeExpectancy.
}
\description{
Adds a new column called LifeExpectancy to the dataset that was input.
LifeExpectancy is how many more years we expect a person of age x to live beyond
their current age.
}
\examples{
# This function will add the ConditionalProbDeath, ConditionalProbLife,
# NumberToSurvive, PropToSurvive, PersonYears, TotalYears, and LifeExpectancy
# columns to the dataset.
# This will be a full lifetable
life_expectancy(mortality2, "age_group", "population", "deaths")
}
