% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{shapeToRaster}
\alias{shapeToRaster}
\title{Load shapefile and convert to a raster object.}
\usage{
shapeToRaster(
  shape,
  size,
  spatial = "spatial.csv",
  coord.x = NULL,
  coord.y = NULL,
  buffer = NULL,
  type = c("land", "water")
)
}
\arguments{
\item{shape}{The path to a shapefile containing land polygons of the study area.}

\item{size}{The pixel size, in metres.}

\item{spatial}{Either a character string specifying the path to a spatial.csv file or a spatial data frame.
This argument is not mandatory, but can be used to perform an early check of the shape file's compatibility
with the study stations and release sites.}

\item{coord.x, coord.y}{The names of the columns containing the x and y positions of the stations
in the spatial.csv file. these coordinates MUST BE in the same coordinate system as the shape file.}

\item{buffer}{Artificially expand the map edges. Can be a single value (applied to all edges)
or four values (xmin, xmax, ymin, ymax). The unit of the buffer depends on the shape file's
coordinate system.}

\item{type}{The type of shapefile being loaded. One of "land", if the shapefile's polygons represent landmasses, or "water", if the shapefile's polygons represent water bodies.}
}
\value{
A raster object.
}
\description{
shapeToRaster can also perform early quality checks on the shape file, to ensure it is compatible
with the remaining study data. To activate these, set the names of the columns in the spatial.csv
file that contain the x and y coordinates of the stations using coord.x and coord.y. By default,
shapeToRaster looks for a spatial.csv file in the current working directory, but this can be
personalized using the spatial argument.
}
\details{
It is highly recommended to read the manual page regarding distances matrices before running this function.
You can find it here: \href{https://hugomflavio.github.io/actel-website/manual-distances.html}{https://hugomflavio.github.io/actel-website/manual-distances.html}
}
\examples{
\donttest{
# check if R can run the distance functions
aux <- c(
  length(suppressWarnings(packageDescription("raster"))),
  length(suppressWarnings(packageDescription("gdistance"))),
  length(suppressWarnings(packageDescription("sp"))),
  length(suppressWarnings(packageDescription("terra"))))

missing.packages <- sapply(aux, function(x) x == 1)

if (any(missing.packages)) {
  message("Sorry, this function requires packages '",
    paste(c("raster", "gdistance", "sp", "terra")[missing.packages], collapse = "', '"),
    "' to operate. Please install ", ifelse(sum(missing.packages) > 1, "them", "it"),
    " before proceeding.")
} else {
  # Fetch actel's example shapefile
  example.shape <- paste0(system.file(package = "actel")[1], "/example_shapefile.shp")

  # import the shape file
  x <- shapeToRaster(shape = example.shape, size = 20)

  # have a look at the resulting raster,
  # where the blank spaces are the land areas
  terra::plot(x)
}
rm(aux, missing.packages)
}
}
