% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_remaining_arms.R
\name{check_remaining_arms}
\alias{check_remaining_arms}
\title{Check remaining arm combinations}
\usage{
check_remaining_arms(object, ci_width = 0.95)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \code{\link[=run_trials]{run_trials()}}
function.}

\item{ci_width}{single numeric \verb{>= 0} and \verb{< 1}, the width of the approximate
confidence intervals for the proportions of combinations (calculated
analytically). Defaults to \code{0.95}, corresponding to 95\% confidence
intervals.}
}
\value{
a \code{data.frame} containing the combinations of remaining arms, sorted
in descending order of, with the following columns:
\itemize{
\item \verb{arm_*}, one column per arm, each named as \verb{arm_<arm name>}. These
columns will contain an empty character string \code{""} for dropped arms
(including arms dropped at the final analysis), and otherwise be
\code{"superior"}, \code{"control"}, \code{"equivalence"} (only if equivalent at the
final analysis), or \code{"active"}, as described in \code{\link[=run_trial]{run_trial()}}.
\item \code{n} integer vector, number of trial simulations ending with the
combination of remaining arms as specified by the preceding columns.
\item \code{prop} numeric vector, the proportion of trial simulations ending
with the combination of remaining arms as specified by the preceding
columns.
\item \code{se},\code{lo_ci},\code{hi_ci}: the standard error of \code{prop} and the confidence
intervals of the width specified by \code{ci_width}.
}
}
\description{
This function summarises the numbers and proportions of all combinations of
remaining arms (i.e., excluding arms dropped for inferiority or futility at
any analysis, and arms dropped for equivalence at earlier analyses in trials
with a common \code{control}) across multiple simulated trial results. The
function supplements the \code{\link[=extract_results]{extract_results()}}, \code{\link[=check_performance]{check_performance()}}, and
\code{\link[=summary]{summary()}} functions, and is especially useful for designs with \verb{> 2} arms,
where it provides details that the other functions mentioned do not.
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 control = "A",
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 200,
                                 equivalence_prob = 0.7,
                                 equivalence_diff = 0.03,
                                 equivalence_only_first = FALSE)

# Run 35 simulations with a specified random base seed
res <- run_trials(binom_trial, n_rep = 25, base_seed = 12345)

# Check remaining arms (printed with fewer digits)
print(check_remaining_arms(res), digits = 3)

}
\seealso{
\code{\link[=extract_results]{extract_results()}}, \code{\link[=check_performance]{check_performance()}}, \code{\link[=summary]{summary()}},
\code{\link[=plot_convergence]{plot_convergence()}}, \code{\link[=plot_metrics_ecdf]{plot_metrics_ecdf()}}.
}
