% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_of_change.R
\name{rate_of_change}
\alias{rate_of_change}
\title{Approximate the Instantaneous Rate of Change}
\usage{
rate_of_change(discharge, dates, smooth = TRUE)
}
\arguments{
\item{discharge}{numeric vector of mean daily discharges}

\item{dates}{vector of dates corresponding to daily discharge measurements.
Must be class \code{"Date"}.}

\item{smooth}{logical indicating if the first derivative is calculated using a cubic smoothing spline function. Defaults is \code{TRUE}.}
}
\value{
Numeric vector with the estimated streamflow rate of change.
}
\description{
Estimate the rate of change or first derivative of the raw mean daily streamflow or the smoothed cubic spline fit between time and mean daily streamflow.
}
\examples{
## calculate the first deriv of the smoothed function between Date and streamflow
rate <- rate_of_change(lavaca$Flow, lavaca$Date)
head(rate)

## Return the first deriv on raw measurements
rate2 <- rate_of_change(lavaca$Flow, lavaca$Date, smooth = FALSE)
head(rate2)

}
