% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpaired.randtest.R
\name{tpaired.randtest}
\alias{tpaired.randtest}
\title{Permutational paired t-test}
\usage{
tpaired.randtest(
  vec1,
  vec2,
  nperm = 99,
  alternative = "two.sided",
  silent = FALSE
)
}
\arguments{
\item{vec1, vec2}{The two data vectors to be compared.}

\item{nperm}{Number of permutations. Use 999, 9999, or more, in real-case applications.}

\item{alternative}{c("two.sided", "less", "greater"). Default value:
"two.sided".}

\item{silent}{If \code{FALSE}, calculation results are printed to the R
console. If \code{TRUE} calculation results are not printed to R console
(e.g. for simulations, or for use inside another function).}
}
\value{
A list containing the following results: \itemize{ \item
  \code{estim}: mean of the differences \item \code{t.ref}: reference value
  of the t-statistic \item \code{p.param}: parametric p-value \item
  \code{p.perm}: permutational p-value \item \code{nperm}: number of
  permutations }
}
\description{
This function computes a permutation test of comparison of the means of two
paired vectors (related samples). For each object, repeated permutations are
restricted to the two related observations.
}
\examples{

## Deer leg length, data from Zar (1999, p. 162).

deer <- matrix(c(142,140,144,144,142,146,149,150,142,148,138,136,147,139,143,141,143,
145,136,146),10,2)

rownames(deer) <- paste("Deer",1:10,sep=".")

colnames(deer) <- c('Hind.leg', 'Fore.leg')

res <- tpaired.randtest(deer[,1], deer[,2])   # Two-tailed test by default

## Compare the results to:  res2 = t.test(deer[,1], deer[,2], paired=TRUE)

}
\references{
Zar, J. H. 1999. \emph{Biostatistical analysis. 4th edition.}
  Prentice Hall, New Jersey.
}
\seealso{
\code{\link[stats]{t.test}}
}
\author{
Pierre Legendre \email{pierre.legendre@umontreal.ca}. Permutation
  code improved by Guillaume Blanchet \email{guillaume.blanchet@usherbrooke.ca}.
}
