% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Episodes.R
\name{rank_episodes}
\alias{rank_episodes}
\title{Rank Episodes of Care}
\usage{
rank_episodes(.data, .permissible_gap = NULL, .initial_rank = 1)
}
\arguments{
\item{.data}{Data frame with a "gap" column appended from \code{identify_gaps()}}

\item{.permissible_gap}{Integer value suggesting the maximum gap allowed before labeling a new episode of care}

\item{.initial_rank}{Integer value to identify what the indexing rank should be (defaults to 1).}
}
\value{
The initial claims data frame with an \code{episode} column appended, which ranks episodes of care in time
}
\description{
This function identifies and labels all episodes of care for a given patient in chronological order. A new episode begins after a specified gap in therapy has occurred. 
It is meant to be used after one has appropriately adjusted dates (\code{propagate_date()}) and identified gaps in therapy (\code{identify_gaps()}).
}
\note{
This function assumes an \code{adjusted_date} column, which is produced by the \code{propagate_date()} function and a
\code{gap} column, which is produced by \code{identify_gaps()}. If you would like to rank episodes of care using other dates and a separate
column for gaps, you'll need to rename those columns before passing the frame to \code{rank_episodes()}. Notably, this is on purpose as this step should
almost always come after the former two.
}
\examples{
library(adheRenceRX)
library(dplyr)

toy_claims \%>\% 
  filter(ID == "D") \%>\% 
  propagate_date() \%>\% 
  identify_gaps() \%>\% 
  rank_episodes(.permissible_gap = 20, .initial_rank = 1)
  
}
