% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_surv_data.R
\name{simulate_surv_data}
\alias{simulate_surv_data}
\title{Simulate stratified and clustered survival data}
\usage{
simulate_surv_data(
  N = 100,
  alpha = 1,
  beta1 = 1 * 1/alpha,
  beta2 = -1 * 1/alpha,
  beta3 = 0.5 * 1/alpha,
  rateC = 0.01,
  stratified = TRUE,
  lambda0 = 1,
  lambda1 = 2
)
}
\arguments{
\item{N}{Total number of clusters. Default is 100.}

\item{alpha}{Parameter for a positive stable distribution. It controls correlation within a cluster. 
\code{1/alpha} must be an integer such that \code{alpha = 0.25, 0.5 and 1}. \code{alpha=1} generates independent data.
As \code{alpha} decreases, the correlation within a cluster increases. Default is 1.}

\item{beta1}{This value multiplied by alpha is the true value of normally distributed covariate effect.}

\item{beta2}{This value multiplied by alpha is the true value of uniformly distributed covariate effect.}

\item{beta3}{This value multiplied the alpha is the true value of bernoulli distributed covariate effect.}

\item{rateC}{Rate of exponential distribution to generate censoring times. Default is 0.01.}

\item{stratified}{It is \code{TRUE} for stratified data. Two strata are considered.}

\item{lambda0}{Constant baseline hazard for first stratum. If \code{stratified=FALSE}, then \code{lambda0}
is used as a constant basline hazard.}

\item{lambda1}{Constant baseline hazard for second stratum.}
}
\value{
Returns a data frame with the following variables:
\item{cluster}{Cluster variable}
\item{times}{Survival times}
\item{delta}{Event indicator with Event=1 and Censoring=0}
\item{Z1}{Standard normal covariate}
\item{Z2}{Cluster level covariate generated from uniform distribution}
\item{Z3}{Bernoulli distributed covariate with probability 0.6}
\item{s}{Stratification variable. This is provided only when \code{stratified=TRUE}}
}
\description{
The function \code{simulate_surv_data} simulates survival data based 
on a marginal proportional hazards model based on \cite{Logan et al. (2011)}.
}
\examples{
#Stratified data
alpha = 0.5
d = simulate_surv_data(N=200,alpha=alpha,beta1=0.5*1/alpha,beta2=-0.5*1/alpha,
beta3=1/alpha,rateC=1.3,lambda0=1,lambda1=2,stratified = TRUE)

#Unstratified data
d = simulate_surv_data(N=200,alpha=alpha,beta1=0.5*1/alpha,beta2=-0.5*1/alpha,
beta3=1/alpha,rateC=0.9,lambda0=1,lambda1=2,stratified = FALSE)
}
\references{
{Logan BR, Zhang MJ, Klein JP. Marginal models for clustered time-to-event data with competing risks using pseudovalues. Biometrics. 2011;67(1):1-7. doi:10.1111/j.1541-0420.2010.01416.x}
}
