% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_studyeye.R
\name{derive_var_studyeye}
\alias{derive_var_studyeye}
\title{Derive Study Eye}
\usage{
derive_var_studyeye(dataset_adsl, dataset_sc, sctestcd_value = "FOCID")
}
\arguments{
\item{dataset_adsl}{ADSL input dataset.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{dataset_sc}{SC input dataset.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{sctestcd_value}{\code{SCTESTCD} value flagging Study Eye selection records.

\describe{
\item{Permitted values}{a character scalar, i.e., a character vector of length one}
\item{Default value}{\code{"FOCID"}}
}}
}
\value{
The input ADSL dataset with an additional column named \code{STUDYEYE}.
}
\description{
Derive Study Eye (\code{STUDYEYE}) in the ADSL dataset
}
\details{
Study Eye is derived in ADSL using the "Study Eye selection" records
in the SC SDTM dataset.
}
\examples{
library(tibble)
library(admiral)

adsl <- tribble(
  ~STUDYID, ~USUBJID,
  "XXX001", "P01",
  "XXX001", "P02",
  "XXX001", "P03",
  "XXX001", "P04",
  "XXX001", "P05"
)

sc <- tribble(
  ~STUDYID, ~USUBJID, ~SCTESTCD, ~SCSTRESC,
  "XXX001", "P01", "FOCID", "OS",
  "XXX001", "P01", "ACOHORT", "COHORT1",
  "XXX001", "P02", "FOCID", "OD",
  "XXX001", "P02", "ACOHORT", "COHORT3",
  "XXX001", "P04", "FOCID", "OU",
  "XXX001", "P05", "FOCID", "OD",
  "XXX001", "P06", "FOCID", "OS"
)

derive_var_studyeye(adsl, sc)
}
\author{
Edoardo Mancini
}
\keyword{der_adsl}
