% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinething.R
\name{domath}
\alias{domath}
\title{Calculate the math of an affine transform}
\usage{
domath(pts, xy, r = NULL, proj = NULL)
}
\arguments{
\item{pts}{known points of 'xy'}

\item{xy}{'xy' obtain from \code{affinething}}

\item{r}{raster in use}

\item{proj}{optional projection, if the pts are longlat and the raster is not}
}
\value{
raster extent
}
\description{
Given relative location and absolute locations, convert to an actual real world extent
for a matrix of data.
}
\details{
Convert known geographic points with raw graphic control points and a reference raster
to an extent for the raster in geography.
}
\examples{
## not a real example, but the extent we could provide volcano if the second set of points
## described the real world positions of the first set of points within the matrix
domath(cbind(c(147, 148), c(-42, -43)), cbind(c(0.2, 0.3), c(0.1, 0.5)), raster::raster(volcano))
}
\seealso{
\code{\link[=affinething]{affinething()}}
}
