% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agread.R
\name{agcalibrate}
\alias{agcalibrate}
\title{Calibrate acceleration data}
\usage{
agcalibrate(raw, verbose = FALSE, tz = "UTC", ...)
}
\arguments{
\item{raw}{data frame of raw acceleration data obtained from}

\item{verbose}{Print the progress of the calibration for the raw data, Default: FALSE}

\item{tz}{the desired timezone, Default: \code{UTC}}

\item{...}{Additional arguments to pass into the agread function}
}
\value{
Returns the calibrated raw acceleration data
}
\description{
This function uses a C++ implementation of the GGIR `g.calibrate` function.
}
\details{
This function uses a C++ implementation of the GGIR `g.calibrate` function to
return calibrated raw acceleration data.
}
\examples{
   path <- system.file("extdata/example.gt3x", package = "agcounts")
   data <- read.gt3x::read.gt3x(path, asDataFrame = TRUE)
   data <- agcalibrate(raw = data)
}
\seealso{
\code{\link[lubridate]{force_tz}}
}
