% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzylogic-tconorm.R
\name{tconorm_minimum}
\alias{tconorm_minimum}
\alias{tconorm_product}
\alias{tconorm_lukasiewicz}
\alias{tconorm_drastic}
\alias{tconorm_fodor}
\title{t-conorms}
\usage{
tconorm_minimum(x, y)

tconorm_product(x, y)

tconorm_lukasiewicz(x, y)

tconorm_drastic(x, y)

tconorm_fodor(x, y)
}
\arguments{
\item{x}{numeric vector with elements in \eqn{[0,1]}}

\item{y}{numeric vector of the same length as \code{x},
with elements in \eqn{[0,1]}}
}
\value{
Numeric vector of the same length as \code{x} and \code{y}.
The \code{i}th element of the resulting vector gives the result
of calculating \code{S(x[i], y[i])}.
}
\description{
Various t-conorms.
Each of these is a fuzzy logic generalization
of the classical alternative operation.
}
\details{
A function \eqn{S: [0,1]\times [0,1]\to [0,1]}
is a \emph{t-conorm} if for all \eqn{x,y,z\in [0,1]} it holds:
(a) \eqn{S(x,y)=S(y,x)};
(b) if \eqn{y\le z}, then \eqn{S(x,y)\le S(x,z)};
(c) \eqn{S(x,S(y,z))=S(S(x,y),z)};
(d) \eqn{S(x, 0)=x}.

The minimum t-conorm is given by \eqn{S_M(x,y)=max(x, y)}.

The product t-conorm is given by \eqn{S_P(x,y)=x+y-xy}.

The Lukasiewicz t-conorm is given by \eqn{S_L(x,y)=min(x+y,1)}.

The drastic t-conorm is given by \eqn{S_D(x,y)=1} iff
\eqn{x,y\in (0,1]}, and \eqn{max(x, y)} otherwise.

The Fodor t-conorm is given by \eqn{S_F(x,y)=1}
iff \eqn{x+y \ge 1}, and \eqn{max(x, y)} otherwise.
}
\references{
Klir G.J, Yuan B., \emph{Fuzzy sets and fuzzy logic. Theory and applications},
Prentice Hall PTR, New Jersey, 1995.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other fuzzy_logic: 
\code{\link{fimplication_minimal}()},
\code{\link{fnegation_yager}()},
\code{\link{tnorm_minimum}()}
}
\concept{fuzzy_logic}
