% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agops-impact.R
\name{index_w}
\alias{index_w}
\title{Woeginger's w-index}
\usage{
index_w(x)
}
\arguments{
\item{x}{a non-negative numeric vector}
}
\value{
a single numeric value
}
\description{
Given a sequence of \eqn{n} non-negative numbers \eqn{x=(x_1,\dots,x_n)},
where \eqn{x_i \ge x_j \ge 0} for \eqn{i \le j},
the \dfn{\eqn{w}-index} (Woeginger, 2008) for \eqn{x} is defined as
\deqn{W(x)=\max\{i=1,\dots,n: x_{j}\ge i-j+1, \forall j=1,\dots,i\}}{
W(x)=max{i=1,\dots,n: x_j >= i-j+1 for all j=1,\dots,i}}
}
\details{
If a non-increasingly sorted vector is given, the function has O(n) run-time.

See \code{\link{index_rp}} for a natural generalization.
}
\references{
Woeginger G. J., An axiomatic characterization of the Hirsch-index.
\emph{Mathematical Social Sciences} 56(2), 2008, pp. 224-232.
}
\seealso{
Other impact_functions: 
\code{\link{index_g}()},
\code{\link{index_h}()},
\code{\link{index_lp}()},
\code{\link{index_maxprod}()},
\code{\link{index_rp}()},
\code{\link{pord_weakdom}()}
}
\concept{impact_functions}
