% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RGBVI.R
\name{RGBVI}
\alias{RGBVI}
\title{RGB based Vegetative Indexes (RGBVI)}
\usage{
RGBVI(R, G, B, vi = c('RCC','GCC','ExG2','ExR','ExGR'
,'GRVI','VDVI','VARI','MGRVI','CIVE','VEG'))
}
\arguments{
\item{R}{a dataframe or matrix contains 'red' values, RGB should have same class and dimension..}

\item{G}{a dataframe or matrix contains 'green' values, RGB should have same class and dimension.}

\item{B}{a dataframe or matrix contains 'blue' values, RGB should have same class and dimension..}

\item{vi}{vegetative indexes to be calculated(see Details).}
}
\value{
A list with length(vi). Each elements represent a vegetative index matrix or data frame.
}
\description{
This function calculate some useful RGB based vegetative indexes.
}
\details{
The \code{vi} parameter should be a characteristic vector and include
at least one of the following VI: 'RCC','GCC','ExG2','ExR','ExGR','GRVI','VDVI','VARI','MGRVI','CIVE','VEG'.
By default, all of the VIs will be calculated.
}
\examples{
# generate R, G, B matrix with range 0~255
R <- matrix(sample(0:255,25), nrow=5, ncol=5)
G <- matrix(sample(0:255,25), nrow=5, ncol=5)
B <- matrix(sample(0:255,25), nrow=5, ncol=5)

# calculate all available rgb vi
vi.all <- RGBVI(R,G,B)

# calculate RCC,GCC,ExGR,MGRVI
vi.4 <- RGBVI(R,G,B,vi=c('RCC','GCC','ExGR','MGRVI'))

}
\references{
De Swaef, T., Maes, W. H., Aper, J., Baert, J., Cougnon, M., Reheul, D., ... & Lootens, P. (2021). Applying RGB-and thermal-based vegetation indices from UAVs for high-throughput field phenotyping of drought tolerance in forage grasses. Remote Sensing, 13(1), 147.
}
