% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.env_var.R
\name{stability.env_var}
\alias{stability.env_var}
\title{Environmental variance}
\usage{
stability.env_var(dataf, res_var, gen_var, env_var, rep_var,
  plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
A numeric vector with environmental variances of genotypes.
}
\description{
This function calculates the Roemer's environmental variance.
}
\examples{
data(exp_data)
stability.env_var(exp_data,"yield","gen","env","rep")
}
\references{
Becker, H.C. and J. Leon. 1988. Stability analysis in plant breeding. Plant Breeding 101: 1-23.
}
