% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{kripp_alpha}
\alias{kripp_alpha}
\title{Calculate Krippendorff's Alpha}
\usage{
kripp_alpha(rater_one, rater_two, additional_raters = NULL)
}
\arguments{
\item{rater_one}{\code{factor} rating of the first coder.}

\item{rater_two}{\code{factor} ratings of the second coder.}

\item{additional_raters}{\code{list} Additional raters with same requirements as \code{rater_one} and \code{rater_two}. If
there are no additional raters set to \code{NULL}.}
}
\value{
Returns a \code{list} containing the results for Krippendorff's Alpha for
nominal and ordinal data.
}
\description{
This function calculates different Krippendorff's Alpha for nominal and ordinal variables.
}
\note{
Missing values are supported.
}
\references{
Krippendorff, K. (2019). Content Analysis: An Introduction to
Its Methodology (4th Ed.). SAGE
}
\seealso{
Other performance measures: 
\code{\link{calc_standard_classification_measures}()},
\code{\link{cohens_kappa}()},
\code{\link{fleiss_kappa}()},
\code{\link{get_coder_metrics}()},
\code{\link{gwet_ac}()},
\code{\link{kendalls_w}()}
}
\concept{performance measures}
