% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_compute_stats.R
\name{compute_stats_aipw}
\alias{compute_stats_aipw}
\title{Compute Risk (Human+AI v. Human)}
\usage{
compute_stats_aipw(Y, D, Z, nuis_funcs, true.pscore = NULL, X = NULL, l01 = 1)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{X}{Pretreatment covariate used for subgroup analysis (vector). Must be the same length as Y, D, Z, and A if provided. Default is NULL.}

\item{l01}{Ratio of the loss between false positives and false negatives}
}
\value{
A tibble the following columns:
\itemize{
 \item \code{Z_focal}: The focal treatment indicator. `1` indicates the treatment group.
 \item \code{Z_compare}: The comparison treatment indicator. `0` indicates the control group.
 \item \code{X}: Pretreatment covariate (if provided).
 \item \code{loss_diff}: The difference in loss between human+AI and human decision
 \item \code{loss_diff_se}: The standard error of the difference in loss
 \item \code{fn_diff}: The difference in false negatives between human+AI and human decision
 \item \code{fn_diff_se}: The standard error of the difference in false negatives
 \item \code{fp_diff}: The difference in false positives between human+AI and human decision
 \item \code{fp_diff_se}: The standard error of the difference in false positives
 }
}
\description{
Compute the difference in risk between human+AI and human decision makers using AIPW estimators.
}
\examples{
compute_stats_aipw(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  nuis_funcs = nuis_func,
  true.pscore = rep(0.5, nrow(NCAdata)),
  X = NULL,
  l01 = 1
)

}
