% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_ai.R
\name{plot_diff_ai_aipw}
\alias{plot_diff_ai_aipw}
\title{Visualize Difference in Risk (AI v. Human)}
\usage{
plot_diff_ai_aipw(
  Y,
  D,
  Z,
  V = NULL,
  A,
  z_compare = 0,
  l01 = 1,
  nuis_funcs = NULL,
  nuis_funcs_ai = NULL,
  true.pscore = NULL,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  zero.line = TRUE,
  arrows = TRUE,
  y.min = -Inf,
  p.title = NULL,
  p.lb = -1,
  p.ub = 1,
  y.lab = "PSA versus Human",
  p.label = c("PSA worse", "PSA better")
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{V}{A matrix of pretreatment covariates (numeric matrix). Optional.}

\item{A}{An observed AI recommendation (binary: numeric vector of 0 or 1).}

\item{z_compare}{A compare treatment indicator (numeric). Default 0.}

\item{l01}{Ratio of the loss between false positives and false negatives. Default 1.}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}. If NULL, the function will compute the nuisance functions using the provided data. Note that \code{V} must be provided if \code{nuis_funcs} is NULL.}

\item{nuis_funcs_ai}{output from \code{\link{compute_nuisance_functions_ai}}}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{zero.line}{A logical indicating whether to include a zero line. Default TRUE.}

\item{arrows}{A logical indicating whether to include arrows. Default TRUE.}

\item{y.min}{A lower bound for the y-axis (numeric). Default -Inf.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -0.2.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 0.2.}

\item{y.lab}{A label for the y-axis (character). Default "PSA versus Human".}

\item{p.label}{A vector of two labels for the annotations (character). Default c("PSA harms", "PSA helps").}
}
\value{
A ggplot object.
}
\description{
Visualize the difference in risk between AI and human decision makers using AIPW estimators.
Generate a plot based on the overall and subgroup-specific results.
}
\examples{
plot_diff_ai_aipw(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  z_compare = 0,
  nuis_funcs = nuis_func,
  nuis_funcs_ai = nuis_func_ai,
  true.pscore = rep(0.5, nrow(NCAdata)),
  l01 = 1,
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender",
  x.order = c("Overall", "Non-white", "White", "Female", "Male"),
  zero.line = TRUE, arrows = TRUE, y.min = -Inf,
  p.title = NULL, p.lb = -0.3, p.ub = 0.3
)

}
