% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.Calibration.R
\name{transferGRparams}
\alias{transferGRparams}
\title{Transfer GR parameters from one donor sub-basin to a receiver sub-basin}
\usage{
transferGRparams(
  InputsModel,
  Param,
  donor,
  receiver,
  default_param = NULL,
  verbose = FALSE
)
}
\arguments{
\item{InputsModel}{A \emph{GRiwrmInputsModel} object (See \link{CreateInputsModel.GRiwrm})}

\item{Param}{\link{numeric} vector of GR model parameters}

\item{donor}{\link{character} id of the node which gives its parameters}

\item{receiver}{\link{character} id of the node which receives the parameters from the donor}

\item{default_param}{\link{numeric} vector of GR model parameters if parameters are missing from the donor}

\item{verbose}{\link{logical} Add information message on donor and receiver}
}
\value{
A \link{numeric} \link{vector} with transferred parameters
}
\description{
This function is used by \code{Calibration.GRiwrmInputsModel} for transferring parameters
to ungauged nodes and
}
\details{
\code{donor} and \code{receiver} nodes should have the same GR model with the same snow
module configuration.

The transfer takes care of:
\itemize{
\item the presence/absence of hydraulic routing parameters between the donor and the receiver
\item the transformation of the X4 parameters of GR models
}
}
