% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_plan.R
\name{alarm_add_plan}
\alias{alarm_add_plan}
\title{Add a reference plan to a set of plans}
\usage{
alarm_add_plan(
  plans,
  ref_plan,
  map = NULL,
  name = NULL,
  calc_polsby = FALSE,
  GEOID = "GEOID",
  year = 2020
)
}
\arguments{
\item{plans}{A \code{redist_plans} object.}

\item{ref_plan}{An \code{integer} vector containing the reference plan,
a block assignment file as a \code{tibble} or \code{data.frame}, or an \code{sf} object where each
row corresponds to a district.}

\item{map}{A \code{redist_map} object. Only required if the \code{redist_plans} object includes summary statistics.}

\item{name}{A human-readable name for the reference plan. Defaults to the name of \code{ref_plan}. If \code{ref_plan} is a
\code{tibble} or \code{data.frame}, it should be the name of the column of \code{ref_plan} that identifies districts.}

\item{calc_polsby}{A logical value indicating whether a Polsby-Popper compactness score should be calculated for the reference plan. Defaults to \code{FALSE}.}

\item{GEOID}{character. If \code{ref_plan} is a \code{tibble} or \code{data.frame}, then it
should correspond to the column of \code{ref_plan} that identifies block \code{GEOID}s.
If \code{ref_plan} is an \code{sf} object, then it should correspond to the column of
\code{ref_plan} that identifies district numbers. Ignored when \code{ref_plan} is numeric.
Default is \code{'GEOID'}.}

\item{year}{the decade to request if passing a \code{tibble} to \code{ref_plan}, either \code{2010} or \code{2020}. Default is \code{2020}.}
}
\value{
A modified \code{redist_plans} object containing the reference plan. Includes summary statistics if the original \code{redist_plans} object had them as well.
}
\description{
Facilitates comparing an existing (i.e., non-simulated) redistricting plan to a set of simulated plans.
}
\examples{
\dontshow{if (Sys.getenv("DATAVERSE_KEY") != '') withAutoprint(\{ # examplesIf}
# requires Harvard Dataverse API key
map <- alarm_50state_map("WY")
pl <- alarm_50state_plans("WY")
pl_new <- alarm_add_plan(pl, ref_plan = c(1), map, name = "example")

# download and load a comparison plan
url <- paste0("https://github.com/PlanScore/Redistrict2020/raw/main/files/",
  "NM-2021-10/Congressional_Concept_A.zip")
tf <- tempfile(fileext = ".zip")
utils::download.file(url, tf)
utils::unzip(tf, exdir = dirname(tf))
baf <- readr::read_csv(file = paste0(dirname(tf), "/Congressional Concept A.csv"),
                       col_types = "ci")
names(baf) <- c("GEOID", "concept_a")
# Add it to the plans object
map_nm <- alarm_50state_map("NM")
plans_nm <- alarm_50state_plans("NM", stats = FALSE)
alarm_add_plan(plans_nm, baf, map = map_nm, name = "concept_a")
\dontshow{\}) # examplesIf}
}
