% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood-space.R
\name{likelihood_map}
\alias{likelihood_map}
\title{Plot log-likelihood space}
\usage{
likelihood_map(likelihood_space, x, y, delta = 10)
}
\arguments{
\item{likelihood_space}{a data frame resulting from a call to \code{likelihood_space}, where columns represent parameter values and an extra column \code{log_likelihoods} with the corresponding log-likelihood for each parameter value combination.}

\item{x}{a string specifying the parameter to be plotted on the x-axis.}

\item{y}{a string specifying the parameter to be plotted on the y-axis.}

\item{delta}{the range of log-likelihood values of which different color codes will be plotted. Defaults to 10.}
}
\value{
#' A \code{ggplot} plot with the corresponding type of plot.
}
\description{
Plot a filled-contour heatmap displaying the log-likelihood space calculated using \code{likelihood_space}.
}
\examples{
\donttest{
if (FALSE){ # takes a while to finish
example_model <- snc(sfestuary)
estimates <- example_model$coefficients$Estimate

likelihood_space <- likelihood_space(y = sfestuary, centers = estimates,
                                     ranges = 1.5, steps_from_center = 10,
                                     calculate = TRUE)

likelihood_map(likelihood_space, "beta0", "beta1", 10)
 }
}
}
