% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcalendar.R
\name{cal_match}
\alias{cal_match}
\title{Calendar matching}
\usage{
cal_match(x, rcalendar)
}
\arguments{
\item{x}{\verb{[Date]}

A date vector to match.}

\item{rcalendar}{\verb{[rcalendar]}

A calendar to look for holiday matches in.}
}
\value{
A character vector the same size as \code{x}.
}
\description{
\code{cal_match()} matches a date in \code{x} to a holiday in \code{rcalendar} and returns
the corresponding holiday name, or \code{NA} if it doesn't exist in the calendar.

If a date corresponds to multiple holidays, the holiday that was added to the
calendar first is returned.

This function is intended to be similar to \code{\link[base:match]{base::match()}}.
}
\examples{
cal <- rcalendar(
  hol_christmas(),
  hol_halloween(),
  hol_new_years_day(),
  hol_us_presidents_day()
)

x <- as.Date(c(
  "2019-01-02",
  "2019-12-25",
  "2018-02-19",
  "2018-02-20",
  "2020-10-31"
))

cal_match(x, cal)
}
