% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clones.R
\name{create_clones}
\alias{create_clones}
\title{Create a synthetic set of clones with a specific underlying clonal structure}
\usage{
create_clones(numb_beta, dual_beta, dual_alpha, alpha_sharing, beta_sharing)
}
\arguments{
\item{numb_beta}{The number of unique betas in the clonal population}

\item{dual_beta}{The proportion of clone that are dual TCRbeta clones, i.e.
has two distinct beta chains}

\item{dual_alpha}{The proportion of clones that are dual TCRalpha clones,
i.e. has two distinct alpha chains}

\item{alpha_sharing}{A vector where the ith position represents the
proportion of alpha chains that are shared by i clones; alpha chains can
be shared by up to 7 clones}

\item{beta_sharing}{A vector where the ith position represents the
proportion of beta chains that are shared by i clones; beta chains can be
shared by up to 5 clones}
}
\value{
A list of four different matrices. Each matrix is has dimensions
   n x 4, where n is the total number of clones and each row represents the
   chains of a clone. Column 1 and column 2 are the beta index/indices of the
   beta chain(s) used by the clone. Column 3 and 4 are the alpha index/indices
   of the alpha chain(s) used by the clone. If a clone has a single beta
   chain, then col 1 and col 2 will be equal. If a clone has a single alpha
   chain, then col 3 and col 4 will be equal.
}
\description{
\code{create_clones()} creates a set of (beta1, beta2, alpha1, alpha2)
   quadruples that represent the indices of the chains of clones. The function
   will take a fixed number of unique beta chains that are in the T cell
   population, and then use the degree of beta and alpha sharing to determine
   the number of unique alpha chains in the populations. These chains will
   then be randomly assigned to each other, with a proportion of them being
   dual TCR clones (i.e. alpha1 != alpha2 and/or beta1 != beta2), forming
   our random list of clones with their chain indices.
}
\examples{
 # Creating a population containing 1000 beta chains; 10\% of clones with
 # dual-beta TCRs and 30\% of clones with dual TCRs; 75\% beta shared by one
 # clone, 20\% by two clones, 5\% by three clones; 80\% alpha chains shared by
 # one clone, 15\% by two clones, and 5\% by three clones

 clones <- create_clones(numb_beta = 1000,
                         dual_alpha = .3,
                         dual_beta  = .06,
                         alpha_sharing = c(0.80, 0.15, 0.05),
                         beta_sharing  = c(0.75, 0.20, 0.05))

}

