% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amVennDiagram.R
\name{amVennDiagram-shiny}
\alias{amVennDiagram-shiny}
\alias{amVennDiagramOutput}
\alias{renderAmVennDiagram}
\title{Shiny bindings for 'amVennDiagram'}
\usage{
amVennDiagramOutput(outputId, width = "100\%", height = "400px")

renderAmVennDiagram(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{a valid CSS dimension (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates an \code{\link{amVennDiagram}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression
(with \code{quote()}); this is useful if you want to save an expression
in a variable}
}
\value{
\code{amVennDiagramOutput} returns an output element that can be
  included in a Shiny UI definition, and \code{renderAmVennDiagram} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{amVennDiagram}
  within Shiny applications and interactive Rmd documents.
}
\examples{
if(require("shiny") && interactive()) {

library(amVennDiagram5)
library(shiny)

sets <- list(A = 1:20, B = 15:38, C = c(0:5, 20, 30:40))
diagram  <- makeVennData(sets)

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      radioButtons(
        "theme", label = "Theme",
        choices = c(
          "default",
          "dark",
          "dataviz",
          "frozen",
          "kelly",
          "material",
          "moonrise",
          "spirited"
        )
      )
    ),
    mainPanel(
      amVennDiagramOutput("diagram", height = "95vh")
    )
  )
)

server <- function(input, output, session) {

  output[["diagram"]] <- renderAmVennDiagram({
    amVennDiagram(
      diagram, theme = input[["theme"]]
    )
  })

}

shinyApp(ui, server)

}
}
