% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_modis}
\alias{download_modis}
\title{Download MODIS product files}
\usage{
download_modis(
  product = c("MOD09GA", "MYD09GA", "MOD09GQ", "MYD09GQ", "MOD09A1", "MYD09A1",
    "MOD09Q1", "MYD09Q1", "MOD11A1", "MYD11A1", "MOD11A2", "MYD11A2", "MOD11B1",
    "MYD11B1", "MOD13A1", "MYD13A1", "MOD13A2", "MYD13A2", "MOD13A3", "MYD13A3",
    "MOD06_L2", "MCD19A2", "VNP46A2"),
  version = "061",
  nasa_earth_data_token = NULL,
  date = c("2023-09-01", "2023-09-01"),
  extent = c(-125, 22, -64, 50),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  hash = FALSE
)
}
\arguments{
\item{product}{character(1).
One of \code{c("MOD09GA", "MOD11A1", "MOD06_L2", "MCD19A2", "MOD13A2", "VNP46A2")}}

\item{version}{character(1). Default is \code{"061"}, meaning v061.}

\item{nasa_earth_data_token}{character(1).
Token for downloading data from NASA. Should be set before
trying running the function.}

\item{date}{character(1 or 2). length of 10. Date or start/end dates for downloading data.
Format "YYYY-MM-DD" (ex. January 1, 2018 = \code{"2018-01-01"}). Note: ignored if
\code{product == "MOD06_L2"}.}

\item{extent}{numeric(4). Bounding box for downloading data.
Format is \code{c(min_lon, max_lon, min_lat, max_lat)}.
Default is \code{c(-125, 22, -64, 50)}, approximately covering the
continental United States.}

\item{directory_to_save}{character(1). Directory to save data.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). Download data or only save wget commands.}

\item{remove_command}{logical(1). Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item HDF (.hdf) files will be stored in year/day_of_year sub-directories within
\code{directory_to_save}.
}
}
\description{
Need maintenance for the directory path change
in NASA EOSDIS. This function first retrieves the all hdf download links
on a certain day, then only selects the relevant tiles from the retrieved
links. Download is only done at the queried horizontal-vertical tile number
combinations. An exception is MOD06_L2 product, which is produced
every five minutes every day.
}
\note{
Due to NASA data access policies, the download scripts generated by this function
require a valid NASA Earthdata token for authentication and include options to slow down the
download speed to avoid server overload and potential blocking of access.

Both dates in \code{date} should be in the same year.
Directory structure looks like
input/modis/raw/\{version\}/\{product\}/\{year\}/\{day_of_year\}.
}
\examples{
\dontrun{
## NOTE: Examples are wrapped in `/dontrun{}` to avoid sharing sensitive
##       NASA EarthData tokden information.
vec_extent <- c(-80, 35, -75, 40)
# example with MOD09GA product
download_modis(
  product = "MOD09GA",
  version = "061",
  date = "2024-01-01",
  extent = vec_extent,
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
# example with MOD06_L2 product
download_modis(
  product = "MOD06_L2",
  version = "6.1",
  extent = vec_extent,
  date = "2024-01-01",
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
# example with VNP46A2 product
download_modis(
  product = "VNP46A2",
  version = "5200",
  date = "2024-01-01",
  extent = vec_extent,
  nasa_earth_data_token = "./pathtotoken/token.txt",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
}
\references{
\insertRef{data_mcd19a22021}{amadeus}

\insertRef{data_mod06l2_2017}{amadeus}

\insertRef{data_mod09ga2021}{amadeus}

\insertRef{data_mod11a12021}{amadeus}

\insertRef{data_mod13a22021}{amadeus}

\insertRef{article_roman2018vnp46}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
