% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{AMBI_sal}
\alias{AMBI_sal}
\title{Minimum AMBI as a linear function of salinity}
\usage{
AMBI_sal(psal, intercept = 3.083, slope = -0.111)
}
\arguments{
\item{psal}{numeric, salinity}

\item{intercept}{numeric, default 3.083}

\item{slope}{numeric, default -0.111}
}
\value{
a numeric value AMBI_min
}
\description{
Used by \code{\link[=DKI2]{DKI2()}}, adjusting the \code{AMBI} index to
account for decreasing species diversity with
decreasing salinity.
}
\details{
\code{\link[=AMBI_sal]{AMBI_sal()}} and \code{\link[=H_sal]{H_sal()}} are named, respectively,
\emph{AMBI_min} and \emph{H_max} in the DKI documentation
\href{https://dce2.au.dk/pub/SR93.pdf}{(Carstensen et al., 2014)}.
They are renamed in ambiR to reflect the fact that
they are functions of salinity and \emph{not} minimum or
maximum values from data being used.
}
\examples{
AMBI_sal(20.1)

}
