% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{LebA_slice_est_approx}
\alias{LebA_slice_est_approx}
\title{Nonparametric estimation of the trawl (sub-) sets
Leb(A), Leb(A intersection A_h), Leb(A setdifference A_h)}
\usage{
LebA_slice_est_approx(esttrawl, Delta, h, adjust_neg = FALSE)
}
\arguments{
\item{esttrawl}{Vector containing estimated trawl function.}

\item{Delta}{Width of the grid on which we observe the data}

\item{h}{Time point used in A intersection A_h and the setdifference
A setdifference A_h}

\item{adjust_neg}{A binary variable determining whether
negative estimates of the trawl function should be set to 0,
the default is FALSE}
}
\value{
LebA

LebAintersection

LebAsetdifference
}
\description{
This function estimates Leb(A), Leb(A intersection A_h), Leb(A\ A_h).
}
\details{
Estimation of the trawl function using the methodology proposed in
Sauri and Veraart (2022).
}
\examples{
\donttest{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 5000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(1726)
#Simulate the trawl process
Poi_data<-ambit::sim_weighted_trawl(my_n, my_delta, "Exp", my_lambda, "Poi", my_v)$path

#Estimate the trawl set and its two slices at time h=2 without bias correction
est1 <- LebA_slice_est(Poi_data, my_delta, h=2)
est1$LebA
est1$LebAintersection
est1$LebAsetdifference

#Estimate the trawl set and its two slices at time h=2 without bias correction
est2 <- LebA_slice_est(Poi_data, my_delta, h=2, biascor=TRUE)
est2$LebA
est2$LebAintersection
est2$LebAsetdifference

#Note that Leb(A)=1/my_lambda for an exponential trawl
}
}
