% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsWeightedTrawl.R
\name{fit_exp_sin_trawl_periodfixed}
\alias{fit_exp_sin_trawl_periodfixed}
\title{Fits an exponential trawl function to equidistant time series data}
\usage{
fit_exp_sin_trawl_periodfixed(
  x,
  tau = 1,
  GMMlag,
  Delta = 1,
  plotacf = FALSE,
  lags = 100
)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{tau}{period in the sine function, the default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is tau}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
lambda: the memory parameter \eqn{\lambda} in the exponential trawl
}
\description{
Fits an exponential trawl function to equidistant time series data
}
\details{
The trawl function is parametrised by the parameter \eqn{\lambda > 0}
 as follows: \deqn{g(x) = e^{\lambda x},  \mbox{ for }  x \le 0.} The
 Lebesgue measure of the corresponding trawl set is given by \eqn{1/\lambda}.
}
