% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{association}
\alias{association}
\title{Find association between variables}
\usage{
association(
  tb,
  categorical = NULL,
  method1 = c("auto", "pearson", "kendall", "spearman"),
  method3 = c("auto", "parametric", "non-parametric"),
  methodMats = NULL,
  use = "everything",
  normality_test_method = c("ks", "anderson", "shapiro"),
  normality_test_pval = 0.05,
  ...
)
}
\arguments{
\item{tb}{tabular data}

\item{categorical}{a vector specifying the names of categorical (character,
factor) columns}

\item{method1}{method for association between continuous-continuous
variables. values can be \code{"auto", "pearson",  "kendall", "spearman"}.
See details for more information.}

\item{method3}{method for association between continuous-categorical
variables. Values can be \code{"auto", "parametric", "non-parametric"}.
See details of \code{\link{CQassociation}} for more information.
Parametric does t-test while non-parametric
does 'Mann-Whitney’ test.}

\item{methodMats}{This parameter can be used to define the methods for
calculating correlation and association at variables pair level. The input is
a square data.frame of dimension - number of columns in \code{tb}. The row
names and column names of \code{methodMats} are the column names of \code{tb}.
The values in the data.frame can be:
\describe{
 \item{between continuous-continuous variables}{from parameter \code{method1}
 - "auto", "pearson",  "kendall", "spearman"}
 \item{between continuous-categorical variables}{from parameter
 \code{method3} - "auto", "parametric", "non-parametric"}
 \item{between categorical-categorical variables}{can be anything}
}
Default is NULL. In that case the method used for
calculating correlation and association will be the inputs from parameters.

This parameter can also tale some other values. See example for more details.
But its advisable to use like mentioned above.}

\item{use}{an optional character string giving a method for computing
association in the presence of missing values. This must be (complete or an
abbreviation of) one of the strings "everything", "all.obs",
"complete.obs", "na.or.complete", or "pairwise.complete.obs". If use is
"everything", NAs will propagate conceptually, i.e., a resulting value will
be NA whenever one of its contributing observations is NA. If use is
"all.obs", then the presence of missing observations will produce an error.
If use is "complete.obs" then missing values are handled by case wise
deletion (and if there are no complete cases, that gives an error).
"na.or.complete" is the same unless there are no complete cases, that gives
NA}

\item{normality_test_method}{method for normality test for a variable.
 Values can be \code{shapiro}
 for Shapiro-Wilk test or
 \code{'anderson'} for 'Anderson-Darling' test of normality or \code{ks} for
'Kolmogorov-Smirnov'}

\item{normality_test_pval}{significance level for normality tests. Default is 0.05}

\item{...}{other parameters passed to \code{cor}, \code{CCassociation},
\code{CQassociation} and \code{QQassociation}}
}
\value{
A list of three tables:
\describe{
 \item{continuous_corr}{correlation among all the continuous variables}
 \item{continuous_pvalue}{Table containing p-value for the correlation test}
 \item{categorical_cramers}{Cramer's V value among all the categorical
 variables}
 \item{categorical_pvalue}{Chi Sq test p-value}
 \item{continuous_categorical}{association value among continuous and
 categorical variables}
 \item{method_used}{A data.frome showing the method used for all pairs
 of variables}
}
}
\description{
\code{association} finds association among all the variables in the data.
}
\details{
This function calculates association value in three categories -
\itemize{
\item between continuous variables (using \code{CCassociation} function)
\item between categorical variables (using \code{QQassociation} function)
\item between continuous and categorical variables (using \code{CQassociation}
  function)
}
For more details, look at the individual documentation of
\code{\link{CCassociation}}, \code{\link{QQassociation}},
\code{\link{CQassociation}}
}
\examples{
tb <- mtcars
tb$cyl <- as.factor(tb$cyl)
tb$vs  <- as.factor(tb$vs)
out <- association(tb, categorical = c("cyl", "vs"))

# To use the methodMats parameter, create a matrix like this
methodMats <- out$method_used

# the values can be changed as per requirement
# NOTE: in addition to the values from parameters method1 and method3,
#       the values in methodMats can also be the values returned by
#       association function. But its advisable to use the options from
#       method1 and method3 arguements
methodMats["mpg", "disp"] <- methodMats["disp", "mpg"] <- "spearman"
out <- association(tb, categorical = c("cyl", "vs"), methodMats = methodMats)
rm(tb)

}
\seealso{
\code{\link{CCassociation}} for Correlation between Continuous variables,
\code{\link{QQassociation}} for Association between Categorical variables,
\code{\link{CQassociation}} for Association between Continuous-Categorical
variables
}
