% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown.R
\name{click_to_play}
\alias{click_to_play}
\title{Click an element to play a frame}
\usage{
click_to_play(selector = "#SVG_1", start = 2)
}
\arguments{
\item{selector}{The ID of the DOM element.}

\item{start}{An integer; the number of frames to execute upon the beginning
of the visualisation. This is useful when one wants to start with some set-up
instead of an empty canvas.}
}
\description{
Playback option for the functions \link{rmd_animate}
and \link{insert_animate}.
}
\examples{
\donttest{
input <- tempfile(fileext = ".Rmd")
output <- tempfile(fileext = ".html")
writeLines('
```{r, echo = FALSE, message = FALSE}
# Run / include the following in a code chunk of an R Markdown document
library(animate)
insert_animate(system.file("tests/basic_points.json", package = "animate"),
               options = click_to_play())
```
', input)
knitr::knit(input, output)
# browseURL(output)
}

}
