% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown.R
\name{loop}
\alias{loop}
\title{Loop through the available frames n times}
\usage{
loop(times = 1, wait = 20)
}
\arguments{
\item{times}{An integer; the number of times to loop.}

\item{wait}{A number; the number of milliseconds to wait for before the
next frame is drawn.}
}
\description{
Playback option for the functions \link{rmd_animate}
and \link{insert_animate}.
}
\examples{
\donttest{
input <- tempfile(fileext = ".Rmd")
output <- tempfile(fileext = ".html")
writeLines('
```{r, echo = FALSE, message = FALSE}
# Run / include the following in a code chunk of an R Markdown document
library(animate)
insert_animate(system.file("tests/Lorenz_system.json.gz", package = "animate"),
               options = loop(times = 2, wait = 15))
```
', input)
knitr::knit(input, output)
# browseURL(output)
}

}
