% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aniview.R
\name{aniview}
\alias{aniview}
\title{Animate an element when it comes into view}
\usage{
aniview(element, animation, ...)
}
\arguments{
\item{element}{An shiny or rmarkdown element.}

\item{animation}{An animation from \href{https://daneden.github.io/animate.css/}{animate.css}}

\item{...}{Additional class element}
}
\description{
Programmatically animate Shiny and R Markdown content when it comes into view.
}
\examples{
library(shiny)

ui <- function(){
fluidPage(
  use_aniview(), # add use_aniview() in the UI
  aniview(h1("Shiny with AniView"), animation = "fadeInUp"),
  aniview(textOutput("text"), animation = "zoomIn")
)
}

server <- function(input, output, session){
 output$text <- renderText({
   print("An animated text.")
 })
}

if(interactive()) shinyApp(ui, server)

}
