% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_functions.R
\name{nll_frailty}
\alias{nll_frailty}
\title{Negative log-likelihood function: frailty}
\usage{
nll_frailty(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  theta = theta,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  d1 = "Weibull",
  d2 = "Weibull",
  d3 = ""
)
}
\arguments{
\item{a1, b1}{location and scale parameters describing background mortality}

\item{a2, b2}{location and scale parameters describing mortality due to
infection}

\item{theta}{parameter describing variance of unobserved variation in
virulence}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column idenifying if event was death (0) or
right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data are
from an infected (1) or uninfected (0) treatment}

\item{d1, d2}{names of probability distributions chosen to describe background
mortality and mortality due to infection, respectively; both default to the
Weibull distribution}

\item{d3}{name of probability distribution chosen to describe unobserved
frailty; choice of 'gamma' or 'inverse Gaussian'}
}
\value{
numeric
}
\description{
Function calculating negative log-likelihood (nll) for the observed patterns
of mortality in infected and uninfected treatments when it assumed there is
unobserved variation in virulence.
}
\details{
The function assumes the unobserved variation in the rate of mortality due to
infection is continuously distributed and follows either the gamma
distribution or the inverse Gaussian distribution, with mean = 1 and variance
= theta.

The nll is based on five parameter functions for the location and
scale parameters for background mortality and mortality due to infection,
respectively, plus a parameter estimating the variance of the unobserved
variation in virulence.
}
\examples{
### Example 1: unobserved variation in virulence described by gamma distribution

# step #1: parameterise nll function to be passed to 'mle2'
    m01_prep_function <- function(a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta){
      nll_frailty(
        a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta,
        data = data_lorenz,
        time = t,
        censor = censored,
        infected_treatment = g,
        d1 = "Gumbel",
        d2 = "Weibull",
        d3 = "Gamma"
        )}

# step #2: send 'prep_function' to 'mle2' for maximum likelihood estimation
    m01 <- mle2(
      m01_prep_function,
      start = list(a1 = 20, b1 = 5, a2 = 3, b2 = 0.1, theta = 2)
      )

    summary(m01)

### Example 2: unobserved variation in virulence described by inverse Gaussian distribution

    m02_prep_function <- function(a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta){
      nll_frailty(
        a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta,
        data = data_lorenz,
        time = t,
        censor = censored,
        infected_treatment = g,
        d1 = "Gumbel",
        d2 = "Weibull",
        d3 = "Inverse Gaussian"
        )}

    m02 <- mle2(
      m02_prep_function,
        start = list(a1 = 20, b1 = 5, a2 = 3, b2 = 0.1, theta = 2)
        )

    summary(m02)

# compare model estimates by AICc
    AICc(m01, m02, nobs = 256)

}
