% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_file.R
\name{nll_proportional_virulence}
\alias{nll_proportional_virulence}
\title{Negative log-likelihood function: nll proportional virulence}
\usage{
nll_proportional_virulence(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  theta = theta,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  reference_virulence = reference_virulence,
  d1 = "Weibull",
  d2 = "Weibull"
)
}
\arguments{
\item{a1, b1}{location and scale parameters describing background mortality}

\item{a2, b2}{location and scale parameters describing mortality due to
infection}

\item{theta}{a constant describing the proportional relationship
of virulence; theta > 0}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column identifying if event was death (0) or
right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data are
from an infected (1) or uninfected (0) treatment}

\item{reference_virulence}{name of data frame column identifying the
infected treatment to use as a reference when estimating virulence;
value of 1 the reference treatment and 2 for treatment to be compared}

\item{d1, d2}{names of probability distributions describing background
mortality and mortality due to infection, respectively; both default to the
Weibull distribution}
}
\description{
Function assuming hazard functions describing virulence are proportional
among infected treatments.
}
\details{
The proportional hazards assumption requires, h1(t) / h2(t) = c,
where h1(t) and h2(t) are two hazard functions at time t,
and c is a constant. In this function the hazard functions for the
increased mortality due to infection are assumed to be proportional for
different infection treatments within the same experiment.

In the default form, one infected treatment is denoted '1' and used as the
reference treatment for virulence against which the virulence in a second
infected population, '2', is scaled. The default function can be extended
to compare multiple treatments against the reference
(see vignette: Worked examples II)
}
\examples{
data01 <- data_lorenz

# create column 'reference_virulence' with values of 1 and 2 when
  # Infectious.dose = 5000 and 160000, respectively, otherwise 0

data01$reference_virulence <- ifelse(data01$g == 0, 0,
 ifelse(data01$g == 1, ifelse(data01$Infectious.dose == 5000, 1,
   ifelse(data01$Infectious.dose == 160000, 2, 0)), 0)
 )

m01_prep_function <- function(
  a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta){
    nll_proportional_virulence(
      a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta,
      data = data01,
      time = t,
      censor = censored,
      infected_treatment = g,
      reference_virulence = reference_virulence,
      d1 = 'Gumbel', d2 = 'Weibull')
      }

m01 <- mle2(m01_prep_function,
  start = list(a1 = 23, b1 = 5, a2 = 4, b2 = 0.2, theta = 1)
  )

summary(m01)

# virulence in the high dose treatment is estimated as
 # ~ 6x greater than in the low dose treatment

}
