% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formating.R
\name{column_format}
\alias{column_format}
\title{Column format class}
\usage{
column_format(
  name = character(0),
  header = character(0),
  latex = character(0),
  formatter = function() NULL
)
}
\arguments{
\item{name}{name of column}

\item{header}{markdown representation of header name}

\item{latex}{latex representation of header name}

\item{formatter}{function that formats the column values. It should take a vector of values and return a character vector of formatted values.}
}
\value{
column_format object
}
\description{
This class is used to define the format of columns in tables, including the name, header, latex representation, and a formatter function.
}
\examples{
R2 <- column_format(
         "R2",
         header = "*R*^2^",
         latex = "$R^2$",
         formatter = \(x, accuracy = the$accuracy, ...) {
                       align_chr(x,
                                 accuracy = accuracy,
                                 trim_leading_zeros = TRUE,
                                 ...)
                       })
R2
R2@header
R2@formatter
}
