% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaEZANOVA.R
\name{apa.ezANOVA.table}
\alias{apa.ezANOVA.table}
\title{Creates an ANOVA table in APA style based output of ezANOVA command from ez package}
\usage{
apa.ezANOVA.table(
  ez.output,
  correction = "GG",
  table.title = "",
  filename,
  table.number = NA
)
}
\arguments{
\item{ez.output}{Output object from ezANOVA command from ez package}

\item{correction}{Type of sphercity correction: "none", "GG", or "HF" corresponding to none, Greenhouse-Geisser and Huynh-Feldt, respectively.}

\item{table.title}{String containing text for table title}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}
}
\value{
APA table object
}
\description{
Creates an ANOVA table in APA style based output of ezANOVA command from ez package
}
\examples{
\dontrun{
# ** Example 1: Between Participant Predictors
#

library(apaTables)
library(ez)

# See format where one row represents one PERSON
# Note that participant, gender, and alcohol are factors

print(goggles)


# Use ezANOVA
# Be sure use the options command, as below, to ensure sufficient digits

options(digits = 10)
goggles_results <- ezANOVA(data = goggles,
                          dv = attractiveness,
                          between = .(gender, alcohol),
                          participant ,
                          detailed = TRUE)


# Make APA table

goggles_table <- apa.ezANOVA.table(goggles_results,
                                  filename="ex1_ez_independent.doc")

print(goggles_table)



#
# ** Example 2: Within Participant Predictors
#

library(apaTables)
library(tidyr)
library(forcats)
library(ez)

# See initial wide format where one row represents one PERSON
print(drink_attitude_wide)

# Convert data from wide format to long format where one row represents one OBSERVATION.
# Wide format column names MUST represent levels of each variable separated by an underscore.
# See vignette for further details.

drink_attitude_long <- gather(data = drink_attitude_wide,
                              key = cell, value = attitude,
                              beer_positive:water_neutral,
                              factor_key=TRUE)

drink_attitude_long <- separate(data = drink_attitude_long,
                                col = cell, into = c("drink","imagery"),
                                sep = "_", remove = TRUE)

drink_attitude_long$drink <- as_factor(drink_attitude_long$drink)
drink_attitude_long$imagery <- as_factor(drink_attitude_long$imagery)

# See new long format of data, where one row is one OBSERVATION.
# As well, notice that we have two columns (drink, imagery)
# drink, imagery, and participant are factors
print(drink_attitude_long)


# Set contrasts to match Field et al. (2012) textbook output

alcohol_vs_water <- c(1, 1, -2)
beer_vs_wine <- c(-1, 1, 0)
negative_vs_other <- c(1, -2, 1)
positive_vs_neutral <- c(-1, 0, 1)
contrasts(drink_attitude_long$drink) <- cbind(alcohol_vs_water, beer_vs_wine)
contrasts(drink_attitude_long$imagery) <- cbind(negative_vs_other, positive_vs_neutral)


# Use ezANOVA
# Be sure use the options command, as below, to ensure sufficient digits

options(digits = 10)
drink_attitude_results <- ezANOVA(data = drink_attitude_long,
                   dv = .(attitude), wid = .(participant),
                   within = .(drink, imagery),
                   type = 3, detailed = TRUE)


# Make APA table

drink_table <- apa.ezANOVA.table(drink_attitude_results,
                                 filename="ex2_repeated_table.doc")

print(drink_table)


#
# ** Example 3: Between and Within Participant Predictors
#

library(apaTables)
library(tidyr)
library(forcats)
library(ez)

# See initial wide format where one row represents one PERSON
print(dating_wide)


# Convert data from wide format to long format where one row represents one OBSERVATION.
# Wide format column names MUST represent levels of each variable separated by an underscore.
# See vignette for further details.

dating_long <- gather(data = dating_wide,
                     key = cell, value = date_rating,
                     attractive_high:ugly_none,
                     factor_key = TRUE)

dating_long <- separate(data = dating_long,
                       col = cell, into = c("looks","personality"),
                       sep = "_", remove = TRUE)

dating_long$looks <- as_factor(dating_long$looks)
dating_long$personality <- as_factor(dating_long$personality)


# See new long format of data, where one row is one OBSERVATION.
# As well, notice that we have two columns (looks, personality)
# looks, personality, and participant are factors

print(dating_long)

# Set contrasts to match Field et al. (2012) textbook output

some_vs_none <- c(1, 1, -2)
hi_vs_av <- c(1, -1, 0)
attractive_vs_ugly <- c(1, 1, -2)
attractive_vs_average <- c(1, -1, 0)
contrasts(dating_long$personality) <- cbind(some_vs_none, hi_vs_av)
contrasts(dating_long$looks) <- cbind(attractive_vs_ugly, attractive_vs_average)


# Use ezANOVA

library(ez)
options(digits = 10)
dating_results <-ezANOVA(data = dating_long, dv = .(date_rating), wid = .(participant),
                        between = .(gender), within = .(looks, personality),
                        type = 3, detailed = TRUE)


# Make APA table

dating_table <- apa.ezANOVA.table(dating_results,
                                 filename = "ex3_mixed_table.doc")
print(dating_table)
}
}
