% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaRegressionBootTable.R
\name{apa.reg.boot.table}
\alias{apa.reg.boot.table}
\title{Creates a regresion table in APA style with bootstrap confidence intervals}
\usage{
apa.reg.boot.table(
  ...,
  filename = NA,
  table.number = NA,
  number.samples = 1000
)
}
\arguments{
\item{...}{Regression (i.e., lm) result objects. Typically, one for each block in the regression.}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{number.samples}{Number of samples to create for bootstrap CIs}
}
\value{
APA table object
}
\description{
Creates a regresion table in APA style with bootstrap confidence intervals
}
\examples{
\dontrun{
#Note: number.samples = 50 below.
#      However, please use a value of 1000 or higher

# View top few rows of goggles data set
# from Discovering Statistics Using R
set.seed(1)
head(album)

# Single block example
blk1 <- lm(sales ~ adverts + airplay, data=album)
apa.reg.boot.table(blk1)
apa.reg.boot.table(blk1,filename="exRegTable.doc")

# Two block example, more than two blocks can be used
blk1 <- lm(sales ~ adverts, data=album)
blk2 <- lm(sales ~ adverts + airplay + attract, data=album)
apa.reg.boot.table(blk1,blk2,filename="exRegBlocksTable.doc")

# Interaction product-term test with blocks
blk1 <- lm(sales ~ adverts + airplay, data=album)
blk2 <- lm(sales ~ adverts + airplay + I(adverts * airplay), data=album)
apa.reg.boot.table(blk1,blk2,filename="exInteraction1.doc")
}
}
\references{
Algina, J. Keselman, H.J. & Penfield, R.J. (2008). Note on a confidence interval for the squared semipartial correlation coefficient. Educational and Psychological Measurement, 68, 734-741.
}
