% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_correlation.R
\name{apa.r.compare.across.samples.from.descriptive}
\alias{apa.r.compare.across.samples.from.descriptive}
\title{Report difference between correlations in markdown APA style from different samples}
\usage{
apa.r.compare.across.samples.from.descriptive(
  r1,
  r2,
  n1,
  n2,
  alternative = "two.sided",
  show.conf.interval = NULL,
  show.N = NULL,
  show.p = NULL,
  show.statistic = NULL
)
}
\arguments{
\item{r1}{Correlation in sample 1}

\item{r2}{Correlation in sample 2}

\item{n1}{Sample size for sample 1}

\item{n2}{Sample size for sample 2}

\item{alternative}{Alternative hypothesis to pass to alternative argument of cocor.indep.groups. Default is "two.sided"}

\item{show.conf.interval}{Show confidence interval or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.N}{Show sample size or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.p}{Show p-value or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.statistic}{Show test statistic or not (TRUE/FALSE). Default behavior is TRUE.}
}
\value{
R Markdown text
}
\description{
Report difference between correlations in markdown APA style from different samples
}
\examples{
apa.r.compare.across.samples.from.descriptive(r1 = .3, r2 =.6, n1 = 70, n2 =80)
}
