% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_apdesign.R
\name{apdesign}
\alias{apdesign}
\title{apdesign: AP coding
\code{apdesign} returns a data frame with additive polynomial coding}
\usage{
apdesign(data, id_var, time_var, center_time, cycle_var, center_cycle,
  max_degree = c(1, 1))
}
\arguments{
\item{data}{A data frame.}

\item{id_var}{A character that indicates the subject identifier in 
\code{data}.}

\item{time_var}{A character that indicates the within-cycle time indicator in 
\code{data}.}

\item{center_time}{A numeric specifying the within-cycle time to center on.}

\item{cycle_var}{A character that indicates the cycle indicator in 
\code{data}.}

\item{center_cycle}{A numeric specifying the cycle to center on.}

\item{max_degree}{A vector of numerics specifying the highest degree for 
each polynomial.}
}
\value{
Output will be a data frame.
}
\description{
apdesign: AP coding
\code{apdesign} returns a data frame with additive polynomial coding
}
\examples{
id <- c(rep(1,10), rep(2, 10))
y <- c(c(10, 15, 21, 20, 23, 25, 27, 25, 28, 29), 
     c(12, 16, 18, 20, 20, 22, 28, 27, 29, 31))
time <- c(c(0.2, 0.5, 0.7), c(0.3, 0.6, 0.75, 0.89), c(0.1, 0.3, 0.8), 
        c(0.3, 0.6, 0.7, 0.85), c(0.2, 0.7, 0.79), c(0.2, 0.5, 0.75))
cycle <- c(rep(1, 3), rep(2, 4), rep(3, 3), rep(1, 4), rep(2, 3), rep(3, 3))
df <- data.frame(id, y, time, cycle)
apdesign(data = df, id = "id", time_var = "time", cycle_var = "cycle", 
         center_cycle = 1, center_time = 0, max_degree = c(2,1))
}

