% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_apdesign_i.R
\name{apdesign_i}
\alias{apdesign_i}
\title{apdesign_i: AP coding for a single subject}
\usage{
apdesign_i(data, cycle_var, center_cycle, time_var, center_time,
  max_degree = c(1, 1), matricies = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{cycle_var}{A character that indicates the cycle indicator in 
\code{data}.}

\item{center_cycle}{A numeric specifying the cycle to center on.}

\item{time_var}{A character that indicates the within-cycle time indicator in 
\code{data}.}

\item{center_time}{A numeric specifying the within-cycle time to center on.}

\item{max_degree}{A vector of numerics specifying the highest degree for 
each polynomial.}

\item{matricies}{If \code{TRUE}, will print the AP, D1 and D2 matricies.}
}
\value{
Output will be a matrix.
}
\description{
apdesign_i: AP coding for a single subject
}
\examples{
y <- c(10, 15, 21, 20, 23, 25, 27, 25, 28, 29)
time <- c(c(0.2, 0.5, 0.7), c(0.3, 0.6, 0.75, 0.89), c(0.1, 0.3, 0.8))
cycle <- c(rep(1, 3), rep(2, 4), rep(3, 3))
df <- data.frame(y, time, cycle)
apdesign_i(data = df, time_var = "time", cycle_var = "cycle", 
         center_cycle = 1, center_time = 0, max_degree = c(2,1))

}

