% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{multidna2multiphyDat}
\alias{multidna2multiphyDat}
\alias{multiphyDat2multidna}
\title{Conversions between multidna and multiphyDat}
\usage{
multidna2multiphyDat(x)

multiphyDat2multidna(x)
}
\arguments{
\item{x}{a \linkS4class{multidna} or \linkS4class{multiphyDat} object.}
}
\description{
The functions \code{multidna2multiphyDat} and \code{multiphyDat2multidna} are used to convert data between \linkS4class{multidna} and  \linkS4class{multiphyDat} classes.
}
\examples{

## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x

## conversion multidna -> multiphyDat
y <- multidna2multiphyDat(x)
y

## check round trip
identical(x, multiphyDat2multidna(y))

}
\seealso{
\itemize{
\item concatenate
\item \code{\link[adegenet]{DNAbin2genind}} to convert single DNAbin objects.
}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}, Zhian N. Kamvar, Klaus Schliep
}
