% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooks_test.R
\name{cooks_test}
\alias{cooks_test}
\title{Identify influential observations}
\usage{
cooks_test(model, n = stats::nobs(model))
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{The number of outliers to return. The default is
all influential observations.}
}
\value{
A vector of influential observations.
}
\description{
\code{cooks_test} returns the observations identified
as influential based on the cooks statistics being
larger than a threshold. \cr\cr The threshold for this
test is the \code{0.5}
quantile of a \eqn{F_{p, n-p}} distribution
where \eqn{p = }\code{length(stats::coef(model))} and
\eqn{n - p = }\code{stats::df.residual(model)}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
cooks_test(lmod)
}
\seealso{
\code{\link[stats]{cooks.distance}}
}
