% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut_functions.R
\name{earf}
\alias{earf}
\title{Shortcut expectation function}
\usage{
earf(x, ...)
}
\arguments{
\item{x}{Input data. Integer variables are recoded as ordered factors with
a warning. See Details.}

\item{...}{Extra parameters to be passed to \code{adversarial_rf}, \code{forde}
and \code{expct}.}
}
\value{
A one row data frame with values for all query variables.
}
\description{
Calls \code{adversarial_rf}, \code{forde} and \code{expct}.
For repeated application, it is faster to save outputs of \code{adversarial_rf}
and \code{forde} and pass them via \code{...} or directly use \code{expct}.
}
\examples{
# What is the expected values of each feature?
earf(iris)

#' # What is the expected values of Sepal.Length?
earf(iris, query = "Sepal.Length")

# What if we condition on Species = "setosa"?
earf(iris, query = "Sepal.Length", evidence = data.frame(Species = "setosa"))


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2023). Adversarial random
forests for density estimation and generative modeling. In \emph{Proceedings
of the 26th International Conference on Artificial Intelligence and
Statistics}, pp. 5357-5375.
}
\seealso{
\code{\link{arf}}, \code{\link{adversarial_rf}}, \code{\link{forde}}, \code{\link{expct}}
}
