% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap-method}
\alias{bootstrap,numeric-method}
\title{Nonparametric Bootstrap Estimation}
\usage{
bootstrap(object, ...)

\S4method{bootstrap}{numeric}(
  object,
  do,
  n,
  ...,
  f = NULL,
  level = 0.95,
  interval = c("basic", "normal", "percentiles")
)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Extra arguments to be passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument and returns a
single numeric value.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
\code{do}) as argument.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}. Only used if \code{f} is
\code{NULL}.}

\item{interval}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{basic}" (the default), "\code{normal}"
or "\code{percentiles}" (see \code{\link[=confidence_bootstrap]{confidence_bootstrap()}}). Any unambiguous substring
can be given. Only used if \code{f} is \code{NULL}.}
}
\value{
If \code{f} is \code{NULL} (the default), \code{bootstrap()} returns a named \code{numeric}
vector with the following elements:
\describe{
\item{\code{original}}{The observed value of \code{do} applied to \code{object}.}
\item{\code{mean}}{The bootstrap estimate of mean of \code{do}.}
\item{\code{bias}}{The bootstrap estimate of bias of \code{do}.}
\item{\code{error}}{The bootstrap estimate of standard error of \code{do}.}
\item{\code{lower}}{The lower limit of the bootstrap confidence interval at \code{level}.}
\item{\code{upper}}{The upper limit of the bootstrap confidence interval at \code{level}}
}

If \code{f} is a \code{function}, \code{bootstrap()} returns the result of \code{f} applied to
the \code{n} values of \code{do}.
}
\description{
Samples randomly from the elements of \code{object} with replacement.
}
\examples{
x <- rnorm(20)

## Bootstrap
bootstrap(x, do = mean, n = 100)

## Estimate the 25th and 95th percentiles
quant <- function(x) { quantile(x, probs = c(0.25, 0.75)) }
bootstrap(x, n = 100, do = mean, f = quant)

## Get the n bootstrap estimates
(z <- bootstrap(x, n = 100, do = mean, f = function(x) { x }))

## Basic bootstrap confidence interval
confidence_bootstrap(z, level = 0.95, type = "basic", t0 = mean(x))
}
\references{
Davison, A. C. & Hinkley, D. V. (1997). \emph{Bootstrap Methods and Their
Application}. Cambridge Series on Statistical and Probabilistic Mathematics.
Cambridge: Cambridge University Press.
}
\seealso{
\code{\link[=confidence_bootstrap]{confidence_bootstrap()}}

Other resampling methods: 
\code{\link{jackknife}()},
\code{\link{resample_multinomial}()},
\code{\link{resample_uniform}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
